from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class FoolMeOnce(Player):
    """
    Forgives one D then retaliates forever on a second D.

    Names:

    - Fool me once: Original name by Marc Harper
    """

    name = "Fool Me Once"
    classifier = {
        "memory_depth": float("inf"),  # Long memory
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    @staticmethod
    def strategy(opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        if not opponent.history:
            return C
        if opponent.defections > 1:
            return D
        return C